/* eslint-disable no-prototype-builtins */

/**
 * Special class to support linked maps in JS
 */
class LinkedHashMap {
  __entries = [];

  __keyByIndex = {};

  put(key, value) {
    if (this.__keyByIndex.hasOwnProperty(key)) {
      const index = this.__keyByIndex[key];
      this.__entries[index][1] = value;
    } else {
      this.__entries.push([key, value]);
      this.__keyByIndex[key] = this.__entries.length - 1;
    }
  }

  get(key) {
    if (this.__keyByIndex.hasOwnProperty(key)) {
      const index = this.__keyByIndex[key];
      return this.__entries[index][1];
    }

    return null;
  }

  entries() {
    return this.__entries;
  }

  toObject() {
    const object = {};

    this.__entries.forEach((entry) => {
      // eslint-disable-next-line prefer-destructuring
      object[entry[0]] = entry[1];
    });

    return object;
  }
}

export default LinkedHashMap;
