const INT_MAX_VALUE = 2147483647;
const INT_MIN_VALUE = -2147483648;

class Mathx {
  static log10(v) {
    return Math.log10(v);
  }

  static ceilLog10(v) {
    return Math.ceil(Math.log10(v));
  }

  static floorLog10(v) {
    return Math.floor(Math.log10(v));
  }

  static roundDown(v, one) {
    return Math.floor(v / one) * one;
  }

  static roundUp(v, one) {
    return Math.ceil(v / one) * one;
  }

  static roundDown10(v) {
    return 10 ** Math.floor(Math.log10(v));
  }

  static roundUp10(v) {
    return 10 ** Math.ceil(Math.log10(v));
  }

  static pseudoLog(val, minAbs) {
    const abs = Math.abs(val);
    if (abs < minAbs) {
      return 0;
    }
    return Math.sign(val) * ((1 + Math.log(abs)) - Math.log(minAbs));
  }

  static compareNanLow(a, b) {
    let result = a - b;
    if (isNaN(a) || isNaN(b)) {
      // NaN > !NaN, but we want them to be under non-NaN values.
      // So if NaNs were in comparison, revert the result
      result = -result;
    }

    return result;
  }

  static subSat(a, b) {
    if (b > 0) {
      if (a < INT_MIN_VALUE + b) {
        return INT_MIN_VALUE;
      }
    } else if (a > INT_MAX_VALUE + b) {
      return INT_MAX_VALUE;
    }

    return a - b;
  }

  static negSat(a) {
    if (a === INT_MIN_VALUE) {
      return INT_MAX_VALUE;
    }
    return -a;
  }

  static absSat(a) {
    return a < 0 ? Mathx.negSat(a) : a;
  }
}

export default Mathx;
