/* eslint-disable no-continue */
import isEqual from 'lodash/isEqual';

class Multiplier {
  static AUTO_MULTIPLIER = 'auto';

  static MULTIPLIERS = [
    new Multiplier(-12, 'p', 0),
    new Multiplier(-9, 'n', 0),
    new Multiplier(-6, 'μ', 0),
    new Multiplier(-3, 'm', 0),
    new Multiplier(0, '', 0),
    new Multiplier(3, 'K', 0),
    new Multiplier(6, 'M', 0),
    new Multiplier(9, 'G', 0),
    new Multiplier(12, 'T', 0),
    new Multiplier(15, 'P', 0),
    new Multiplier(18, 'E', 0),
  ];

  /**
   * @param {number} e
   * @param {string} suffix
   * @param {number} digitsAfterPointOverride
   */
  constructor(e, suffix, digitsAfterPointOverride) {
    this.e = e;
    this.c = 10.0 ** e;
    this.suffix = suffix;
    this.digitsAfterPointOverride = digitsAfterPointOverride;
  }

  /**
   * @param {number} value
   * @return {Multiplier} most relevant multiplier for value
   */
  static getMultiplierForNumber(value) {
    for (let i = 0; i < Multiplier.MULTIPLIERS.length; ++i) {
      const m = Multiplier.MULTIPLIERS[i];
      if (value >= m.c && value < m.c * 1000) {
        if (i !== Multiplier.MULTIPLIERS.length - 1) {
          const next = Multiplier.MULTIPLIERS[i + 1];
          if (value === next.c) {
            // Some issues with precise work with small numbers.
            // 0.000001 was assigned to multiplier 'n' without this check
            continue;
          }
        }
        if (m.e === -3) {
        // 0.017 is better than 17m
          return new Multiplier(0, '', 3);
        }

        return m;
      }
    }

    return new Multiplier(0, '');
  }

  /**
   * Compute multiplier for suffix
   * @param {string} s
   * @param {Multiplier} auto
   * @return {Multiplier}
   */
  static forSuffix(s, auto) {
    if (isEqual(Multiplier.AUTO_MULTIPLIER, s)) {
      return auto;
    }
    for (let i = 0; i < Multiplier.MULTIPLIERS.length; ++i) {
      const m = Multiplier.MULTIPLIERS[i];
      if (m.suffix === s) {
        return m;
      }
    }
    return Multiplier.forSuffix('', auto);
  }

  static isValid(multiplier) {
    if (isEqual(Multiplier.AUTO_MULTIPLIER, multiplier)) {
      return true;
    }

    for (let i = 0; i < Multiplier.MULTIPLIERS.length; ++i) {
      const m = Multiplier.MULTIPLIERS[i];
      if (m.suffix === multiplier) {
        return true;
      }
    }
    return false;
  }
}

export default Multiplier;
