class NumberFormatter {
  /**
   * @param {number} digits
   * @param {Multiplier} m
   */
  constructor(digits, m) {
    this.m = m;
    this.digits = digits;
  }

  format(value) {
    if (isNaN(value)) {
      return 'No data';
    }

    const number = value / this.m.c;
    return number.toFixed(this.digits) + this.m.suffix;
  }
}

export default NumberFormatter;
