import { isWhitespace } from './CharUtils';

export function consumeEscapedString(parser, quote) {
  let result = '';
  while (parser.hasNext() && parser.lookaheadChar() !== quote) {
    let c = parser.consumeChar();
    if (c === '\\') {
      c = parser.consumeChar();
      if (c === '\\' && c === quote) {
        result += '\\';
      }
    }
    result += c;
  }

  return result;
}

export function consumeQuotedString(parser, stopSymbols) {
  if (!parser.hasNext()) {
    return '';
  }

  const firstCh = parser.lookaheadChar();

  if (firstCh === '"' || firstCh === '\'') {
    parser.consumeChar();

    const value = consumeEscapedString(parser, firstCh);

    parser.consumeExpectedChar(firstCh);

    return value;
  }

  return parser.consumeWhile((ch) => stopSymbols.indexOf(ch) < 0 && !isWhitespace(ch));
}

export function singleQuote(text) {
  return `'${text.replace(/'/g, '\\\'')}'`;
}

export function doubleQuote(text) {
  return `"${text.replace(/"/g, '\\"')}"`;
}

export function escapeQuotes(text) {
  return text.replace(/"/g, '\\"').replace(/'/g, '\\\'');
}
