import React from 'react';
import { convertOldToNewSelectors, makeOldUiGraphUrl } from './SelectorUtils';
import Selectors from './Selectors';
import { replaceSelectorsInCode, SELECTORS_PART_TYPE } from './SelectorsReplacer';

function selectorsHighlighter(type, text, selectors, params) {
  const { projectId } = params;

  let nameSelector = '';
  let parsedSelectors;
  if (type === SELECTORS_PART_TYPE) {
    parsedSelectors = Selectors.parse(selectors);
    nameSelector = parsedSelectors.getNameSelector();
    parsedSelectors = new Selectors('', parsedSelectors.getSelectors());
  } else {
    parsedSelectors = convertOldToNewSelectors(selectors);
  }

  const url = makeOldUiGraphUrl(projectId, parsedSelectors);

  if (nameSelector) {
    nameSelector = Selectors._formatNameSelector(nameSelector);
  }

  if (url) {
    return {
      part: (
        <>
          {nameSelector}
          <a href={url}>{parsedSelectors.format(true)}</a>
        </>
      ),
      isOk: true,
    };
  }

  return {
    part: <span className="text-danger">{text}</span>,
    isOk: false,
  };
}

/**
 * Divide code to parts with replaced selectors
 *
 * @param {String} projectId
 * @param {String} code
 * @return { {result, allReplaced} } result of code replacement
 */
export function highlightSelectorsInCode(projectId, code) {
  try {
    return replaceSelectorsInCode(code, selectorsHighlighter, { projectId });
  } catch (e) {
    console.error('failed to replace selectors in code', e);
    return { result: [code], allReplaced: true };
  }
}

export default {};
