/* eslint-disable import/no-cycle */
import UrlUtils from './url/UrlUtils';

class UserLinksBasic {
  // This selectors cannot support complex label selector syntax search
  static SPECIAL_LABEL_SELECTOR_NAMES =
    ['cluster', 'service', 'graph', 'dashboard'];

  static GRAPH_ONLY_QA = 'graphOnly';

  static LABEL_NAME_QA_PREFIX = 'l.';

  static NEED_POINTS_PARAM = 'points';

  static DROP_NANS_PARAM = 'dropNaN';

  static FORCE_HOST_PARAM = 'forceHost';

  static FORCE_CLUSTER_PARAM = 'forceCluster';

  static FORCE_HOST_LOCAL_VALUE = 'local';

  static REVIVER_CLIENT_ID = 'reviverClientId';

  static PROJECT = 'project';

  static CLUSTER = 'cluster';

  static SERVICE = 'service';

  static GRAPH_PARAM = 'graph';

  static DASHBOARD_PARAM = 'dashboard';

  static GRAPH_VALUE_AUTO = 'auto';

  static GRAPH_DESCRIPTION = 'description';

  static SCALE_PARAM = 'scale';

  static SCALE_NATURAL = 'natural';

  static SCALE_LOG = 'log';

  static STACK_PARAM = 'stack';

  static NORM_PARAM = 'norm';

  static LEGEND_QUERY_ARG = 'legend';

  static HIDE_NO_DATA_QUERY_ARG = 'hideNoData';

  static IGNORE_INF_PARAM = 'ignoreInf';

  static INTERPOLATE_PARAM = 'interpolate';

  static GRAPH_MODE = 'graphMode';

  static SECONDARY_GRAPH_MODE = 'secondaryGraphMode';

  static COLOR_SCHEME_QUERY_ARG = 'cs';

  static COLOR_SCHEME_GRADIENT = 'gradient';

  static GRAPH_MODE_GRAPH = 'graph';

  static GRAPH_MODE_PIE_CHART = 'pieChart';

  static GRAPH_MODE_BARS = 'bars';

  static GRAPH_MODE_DISTRIBUTION = 'distribution';

  static GRAPH_MODE_HEATMAP = 'heatmap';

  static GRAPH_MODE_NONE = 'none';

  static HEATMAP_GREEN_VALUE_QUERY_ARG = 'greenValue';

  static HEATMAP_YELLOW_VALUE_QUERY_ARG = 'yellowValue';

  static HEATMAP_RED_VALUE_QUERY_ARG = 'redValue';

  static HEATMAP_VIOLET_VALUE_QUERY_ARG = 'violetValue';

  static GRAPH_NUMBER_FORMAT = 'numberFormat';

  static GREEN_QUERY_ARG = 'green';

  static YELLOW_QUERY_ARG = 'yellow';

  static RED_QUERY_ARG = 'red';

  static VIOLET_QUERY_ARG = 'violet';

  static AGGR_PARAM = 'aggr';

  static MIN_PARAM = 'min';

  static MAX_PARAM = 'max';

  static AUTOREFRESH_QA = 'autorefresh';

  static B_QA = 'b';

  static E_QA = 'e';

  static CHECKS_QA = 'checks';

  static IS_BACKGROUND_QUERY_PARAM = 'backgroudQuery';

  static PERCENTILE_PARAM = 'percentiles';

  static BUCKET_LABEL_PARAM = 'bucketLabel';

  static METADATA_VERSION_HASH_PARAM = 'clientMetaDataVersionHash';

  static DEV_GENERATE_TEST_DATA = 'devGenerateTestData';

  static SOLOMON_CLIENT_VERSION = 'solomonClientVersion';

  static WHO = 'who';

  static SHOW_CENSORED_INTERVALS = 'showCensoredIntervals';

  static DATA_DELAY = 'dataDelay';

  static SENSORS = 'metrics';

  static SENSORS_DATA = 'sensorsData';

  // param to distinct user action from autorefresh (https://st.yandex-team.ru/SOLOMON-1466)
  static COUNT_USAGE = 'countUsage';

  static CHART_BORDER_WIDTH = 'chartBorderWidth';

  static DISTRIBUTION_MODE = 'distributionMode';

  static TEXT_SEARCH = 'textSearch';

  static PROJECT_SEARCH = 'projectSearch';

  static FRONTEND_BUG_KEY_SEARCH = 'keySearch';

  static TRANSFORM = 'transform';

  static OVER_LINES_TRANSFORM = 'overLinesTransform';

  static MIN_DATAMIN = 'datamin';

  static FILTER = 'filter';

  static FILTER_BY = 'filterBy';

  static FILTER_LIMIT = 'filterLimit';

  // Downsampling params
  static DOWNSAMPLING = 'downsampling';

  static DOWNSAMPLING_AGGR = 'downsamplingAggr';

  static DOWNSAMPLING_FILL = 'downsamplingFill';

  static IGNORE_MIN_STEP_MILLIS = 'ignoreMinStepMillis';

  static GRID = 'grid';

  static MAX_POINTS = 'maxPoints';

  // Downsampling aggr values
  static DOWNSAMPLING_PARAM_AUTO = 'auto';

  static DOWNSAMPLING_PARAM_WITHOUT_GRID = 'withoutGrid';

  static DOWNSAMPLING_PARAM_BY_INTERVAL = 'byInterval';

  static DOWNSAMPLING_PARAM_BY_POINTS = 'byPoints';

  static DOWNSAMPLING_PARAM_OFF = 'off';

  // For Data API
  static DOWNSAMPLING_PARAM_RAW = 'raw';

  static MOVING_WINDOW = 'movingWindow';

  static MOVING_PERCENTILE = 'movingPercentile';

  static CLONE_OF_ARG = 'cloneOf';

  static enforceGraphOnly(url) {
    if (UserLinksBasic.isSolomonUrl(url) && url.indexOf(UserLinksBasic.GRAPH_ONLY_QA) <= 0) {
      const urlFixed = UserLinksBasic.fixSolomonUrl(url);
      return UrlUtils.addParameter(urlFixed, UserLinksBasic.GRAPH_ONLY_QA, '1');
    }

    return url;
  }

  static isSolomonUrl(url) {
    return url.startsWith('/') || url.startsWith('?') || url.startsWith('#');
  }

  static fixSolomonUrl(url) {
    if (url.startsWith('/?')) {
      return url;
    }
    if (url.startsWith('?')) {
      return `/${url}`;
    }
    if (url.startsWith('#')) {
      return UserLinksBasic.fixSolomonUrl(url.substring(1));
    }
    if (url.startsWith('/#')) {
      return UserLinksBasic.fixSolomonUrl(url.substring(2));
    }
    return url;
  }

  static isGeneric(link) {
    const fixedLink = UserLinksBasic.fixSolomonUrl(link);
    // generic page
    return fixedLink.startsWith('/?');
  }

  static fixOldAdminUrl(url) {
    if (window.location.pathname.indexOf('/admin/old') >= 0) {
      if (url.startsWith('/')) {
        return `/admin/old${url}`;
      }
      if (url.startsWith('?')) {
        return `/admin/old/${url}`;
      }
      return url;
    }

    if (window.location.pathname.indexOf('/admin/compareModes') >= 0) {
      if (url.startsWith('/')) {
        return `/admin/compareModes${url}`;
      }
      if (url.startsWith('?')) {
        return `/admin/compareModes/${url}`;
      }
      return url;
    }

    return url;
  }

  static unfixOldAdminUrl(url) {
    return url.replace('/admin/old', '').replace('/admin/compareModes', '');
  }

  static isLocal(link) {
    const fixedLink = UserLinksBasic.fixSolomonUrl(link);
    return fixedLink.startsWith('/');
  }

  static labelNameToQueryArgName(labelName) {
    if (UserLinksBasic.isPartOfShardKey(labelName)) {
      return labelName;
    }
    return UserLinksBasic.LABEL_NAME_QA_PREFIX + labelName;
  }

  static isPartOfShardKey(labelName) {
    switch (labelName.toLowerCase()) {
      case 'project':
      case 'cluster':
      case 'service':
        return true;
      default:
        return false;
    }
  }

  static isSpecialSelectorName(labelName) {
    return UserLinksBasic.SPECIAL_LABEL_SELECTOR_NAMES.indexOf(labelName) >= 0;
  }

  static removeGraphOnly(url) {
    if (UserLinksBasic.isSolomonUrl(url) && url.indexOf(UserLinksBasic.GRAPH_ONLY_QA) >= 0) {
      const urlFixed = UserLinksBasic.fixSolomonUrl(url);
      return UrlUtils.removeQueryArgs(urlFixed, UserLinksBasic.GRAPH_ONLY_QA);
    }
    return url;
  }
}

export default UserLinksBasic;
