export function isTrue(s) {
  if (s == null) {
    return false;
  }
  switch (s) {
    case 'on':
    case 'true':
    case 't':
    case 'yes':
    case 'y':
    case '1':
      return true;
    default:
      return false;
  }
}

export function isFalse(s) {
  if (s == null) {
    return false;
  }
  switch (s) {
    case 'off':
    case 'false':
    case 'f':
    case 'no':
    case 'n':
    case '0':
      return true;
    default:
      return false;
  }
}

function parseBoolean(s) {
  if (isTrue(s)) {
    return true;
  }

  if (isFalse(s)) {
    return false;
  }

  return null;
}

export function isTrueOrPositive(s) {
  if (isTrue(s)) {
    return true;
  }
  if (!s) {
    return false;
  }
  const c = s[0];
  return c >= '0' && c <= '9';
}

export default parseBoolean;
