import GradientZone from './GradientZone';

class GradientColor {
  static GREEN = 0;

  static YELLOW = 1;

  static RED = 2;

  static VIOLET = 3;

  static GREEN_VALUE = new GradientColor(GradientZone.GREEN_YELLOW, 0, 0);

  static YELLOW_VALUE = new GradientColor(GradientZone.YELLOW_RED, 0, 1);

  static RED_VALUE = new GradientColor(GradientZone.RED_VIOLET, 0, 2);

  static VIOLET_VALUE = new GradientColor(GradientZone.RED_VIOLET, 1, 3);

  static _properties = {
    [GradientColor.GREEN]: GradientColor.GREEN_VALUE,
    [GradientColor.YELLOW]: GradientColor.YELLOW_VALUE,
    [GradientColor.RED]: GradientColor.RED_VALUE,
    [GradientColor.VIOLET]: GradientColor.VIOLET_VALUE,
  };

  static _values = [
    GradientColor.GREEN_VALUE,
    GradientColor.YELLOW_VALUE,
    GradientColor.RED_VALUE,
    GradientColor.VIOLET_VALUE,
  ];

  static values() {
    return GradientColor._values;
  }

  static getProperty(name) {
    return GradientColor._properties[name];
  }

  constructor(gradientZone, gradientPosition, ordinal) {
    this.gradientZone = gradientZone;
    this.gradientPosition = gradientPosition;
    this.ordinal = ordinal;
  }

  getGradientZone() {
    return this.gradientZone;
  }

  getGradientPosition() {
    return this.gradientPosition;
  }

  getOrdinal() {
    return this.ordinal;
  }
}

export default GradientColor;
