class LineColor {
  static Type = {
    AUTO: 'auto',
    GRADIENT: 'gradient',
    FIXED: 'fixed',
  };

  static _AUTO_COLOR = new LineColor(LineColor.Type.AUTO, null, null);

  static gradientColor(zone, position) {
    return new LineColor(LineColor.Type.GRADIENT, zone, position);
  }

  static autoColor() {
    return LineColor._AUTO_COLOR;
  }

  constructor(type, zone, position) {
    this.type = type;
    this.zone = zone;
    this.position = position;
  }
}

export default LineColor;
