import { formatSearch } from './url';

function createShortUrl(url) {
  const params = {
    json: 'on',
    url,
  };

  const requestUrl = `https://nda.ya.ru/--?${formatSearch(params)}`;

  return fetch(requestUrl)
    .then((result) => {
      if (result.ok) {
        return result.json();
      }

      return Promise.reject(new Error('result is not ok'));
    })
    .then((resp) => Promise.resolve(resp[0]));
}

export default createShortUrl;
