export default function debounce(func, delayMillis) {
  let timer = null;
  return (...args) => {
    clearTimeout(timer);
    timer = setTimeout(() => func.apply(this, args), delayMillis);
  };
}
