const HOST_STYLE = {
  MAN: 'primary',
  SAS: 'success',
  MYT: 'warning',
};

const HOST_WITH_DC = /-(man|sas|myt)-/;

export function shortHostname(host) {
  const i = host.indexOf('.');
  return (i === -1) ? host : host.substring(0, i);
}

export function hostStyle(host) {
  if (host in HOST_STYLE) {
    return HOST_STYLE[host];
  }

  const match = HOST_WITH_DC.exec(host);
  if (match) {
    const dcName = match[1].toUpperCase();
    return HOST_STYLE[dcName];
  }

  return 'default';
}
