const ISO_8601_REGEXP = /(\d{4})-(\d{2})-(\d{2})[Tt ](\d{2})[:-](\d{2})[:-](\d{2})(\.\d+)?Z/;

/**
 * Parse datetime text in ISO-8601 format
 *
 * @param {string} text to parse
 * @returns {number} parsed UNIX-epoch milliseconds or NaN
 */
export function parseISO8601(text) {
  const matchResult = ISO_8601_REGEXP.exec(text);
  if (matchResult == null) {
    return NaN;
  }
  const year = parseInt(matchResult[1], 10);
  const month = parseInt(matchResult[2], 10) - 1;
  const day = parseInt(matchResult[3], 10);
  const hour = parseInt(matchResult[4], 10);
  const minute = parseInt(matchResult[5], 10);
  const second = parseInt(matchResult[6], 10);

  return Date.UTC(year, month, day, hour, minute, second, 0);
}

export function formatISO8601(millis) {
  return new Date(millis).toISOString();
}
