export const ITEM_STATE = {
  ACTIVE: 'ACTIVE',
  RW: 'RW',
  READ_ONLY: 'READ_ONLY',
  WRITE_ONLY: 'WRITE_ONLY',
  INACTIVE: 'INACTIVE',
};

export const ITEM_STATES = [
  ITEM_STATE.RW, ITEM_STATE.READ_ONLY, ITEM_STATE.WRITE_ONLY, ITEM_STATE.INACTIVE,
];

export const ITEM_STATE_TITLES = [
  'Active', 'Read only', 'Write only', 'Inactive',
];

export function parseItemState(itemState) {
  if (!itemState) {
    return ITEM_STATE.RW;
  }

  for (let i = 0; i < ITEM_STATES.length; ++i) {
    const currentItemState = ITEM_STATES[i];
    if (itemState === currentItemState) {
      return currentItemState;
    }
  }

  return ITEM_STATE.RW;
}

export function isDefaultItemState(itemState) {
  return itemState === ITEM_STATE.ACTIVE || itemState === ITEM_STATE.RW;
}

export default ITEM_STATE;
