/* eslint-disable no-restricted-syntax */
export function labelsToStr(list) {
  return list ? list.join(' ') : '';
}

export function strToLabels(str) {
  return str ? str.split(/\s+/) : [];
}

export function findNonUniqueLabels(series) {
  if (series.length <= 1) {
    return new Set();
  }

  const firstLabels = { ...series[0].labels };

  const allLabels = new Set();
  const nonUniqueLabels = new Set();

  for (let i = 1; i < series.length; ++i) {
    const curLabels = series[i].labels;

    // eslint-disable-next-line guard-for-in
    for (const label in curLabels) {
      allLabels.add(label);

      const curLabelValue = curLabels[label];
      const firstLabelValue = firstLabels[label];

      if (curLabelValue !== firstLabelValue) {
        nonUniqueLabels.add(label);
      }
    }
  }

  for (const label in firstLabels) {
    if (!allLabels.has(label)) {
      nonUniqueLabels.add(label);
    }
  }

  return nonUniqueLabels;
}
