const LOCAL_DATE_PATTERN = /(\d+)-(\d+)-(\d+) (\d+):(\d+):(\d+)(\.(\d+))?/;

function fillZeros(num, count = 2) {
  let str = `${num}`;

  while (str.length < count) {
    str = `0${str}`;
  }

  return str;
}

/**
 * Format date to local datetime string
 *
 * @param {Date} date
 */
export function formatLocalDate(date) {
  const year = date.getFullYear();
  const month = fillZeros(date.getMonth() + 1);
  const day = fillZeros(date.getDate());
  const hours = fillZeros(date.getHours());
  const minutes = fillZeros(date.getMinutes());
  const seconds = fillZeros(date.getSeconds());
  const milliseconds = fillZeros(date.getMilliseconds(), 3);

  let str = `${year}-${month}-${day} ${hours}:${minutes}:${seconds}`;

  if (milliseconds !== '000') {
    str += `.${milliseconds}`;
  }

  return str;
}

/**
 * Parse datetime text to Date
 *
 * @param {string} text
 */
export function parseLocalDate(text) {
  const match = text.match(LOCAL_DATE_PATTERN);

  if (match === null) {
    return null;
  }

  const year = parseInt(match[1], 10);
  const month = parseInt(match[2], 10) - 1;
  const day = parseInt(match[3], 10);
  const hours = parseInt(match[4], 10);
  const minutes = parseInt(match[5], 10);
  const seconds = parseInt(match[6], 10);
  const milliseconds = match[8] ? parseInt(match[8], 10) : 0;

  return new Date(year, month, day, hours, minutes, seconds, milliseconds);
}
