const UNIT_BASE = 1024;
const UNIT_SYMBOLS = [
  'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB',
];

// eslint-disable-next-line no-use-before-define
const UNITS = makeUnits(UNIT_SYMBOLS, UNIT_BASE);

const DEFAULT_PRECISION = 1;

function makeUnits(unitSymbols, base) {
  const units = [];
  let unitSize = 1;
  for (let i = 0; i < unitSymbols.length; ++i) {
    const unitSymbol = unitSymbols[i];
    unitSize *= base;
    units.push({ size: unitSize, symbol: unitSymbol });
  }
  return units;
}

export function numberToDisplaySize(number, precision = DEFAULT_PRECISION) {
  if (number < 0) {
    return `-${numberToDisplaySize(-number)}`;
  }
  for (let i = UNITS.length - 1; i >= 0; --i) {
    const unit = UNITS[i];
    if (number >= unit.size) {
      const fixedNumber = (number / unit.size).toFixed(precision);
      return `${fixedNumber} ${unit.symbol}`;
    }
  }
  return number;
}

export function roundNumericString(str, precision = 2) {
  if (str !== '' && !isNaN(str)) {
    const num = parseFloat(str);
    const base = 10 ** precision;

    return `${Math.round(num * base) / base}`;
  }

  return str;
}

export default {};
