const LOCATION_KEY = 'solomon-location';

export function saveLocation() {
  const ss = window.sessionStorage;
  if (ss !== undefined) {
    ss.setItem(LOCATION_KEY, window.location);
  }
}

export function tryRestoreLocation() {
  const ss = window.sessionStorage;
  if (ss !== undefined) {
    let location = ss.getItem(LOCATION_KEY);
    if (location) {
      ss.removeItem(LOCATION_KEY);
      // hack to replace incorrect domain name
      if (typeof location === 'string') {
        location = location.replace('solomon.cloud-prod.', 'solomon.cloud.');
      }
      window.location.replace(location);
    }
  }
}
