/* eslint-disable no-param-reassign,no-continue,no-plusplus */
function isDigit(c) {
  return c >= '0' && c <= '9';
}

function digitsPrefixLength(s, pos) {
  let r = 0;
  while (pos + r < s.length && isDigit(s.charAt(pos + r))) {
    ++r;
  }
  return r;
}

function boolCompare(b1, b2) {
  if (b1) {
    return b2 ? 0 : 1;
  }

  return b2 ? -1 : 0;
}

function compareImpl(s1, p1, s2, p2) {
  while (p1 !== s1.length && p2 !== s2.length) {
    const d1Len = Math.min(digitsPrefixLength(s1, p1), 17);
    const d2Len = Math.min(digitsPrefixLength(s2, p2), 17);
    if (d1Len > 0 && d2Len > 0) {
      // lame
      const d1 = parseInt(s1.substring(p1, p1 + d1Len), 10);
      const d2 = parseInt(s2.substring(p2, p2 + d2Len), 10);
      const c = d1 - d2;
      if (c !== 0) {
        return c;
      }
      p1 += d1Len;
      p2 += d2Len;
      continue;
    }

    const d1 = s1.charCodeAt(p1);
    const d2 = s2.charCodeAt(p2);
    const c = d1 - d2;
    if (c !== 0) {
      return c;
    }
    ++p1;
    ++p2;
  }

  return boolCompare(p1 !== s1.length, p2 !== s2.length);
}

const compareTextWithNumber = (s1, s2) => compareImpl(s1, 0, s2, 0);

export default compareTextWithNumber;
