/* eslint-disable prefer-template */
function toFixedWidthString(number, width) {
  const str = `0000000000${number}`;
  return str.substring(str.length - width);
}

class TimeFormatUtils {
  static formatUtcMillis(millis) {
    return new Date(millis).toISOString();
  }

  static parseUtc(utc) {
    const r = /(\d{4})-(\d{2})-(\d{2})[Tt ](\d{2})[:-](\d{2})[:-](\d{2})(\.\d+)?Z/;
    const matchResult = r.exec(utc);
    if (!matchResult) {
      throw new Error(`invalid UTC string: ${utc}`);
    }
    const year = parseInt(matchResult[1], 10);
    const month = parseInt(matchResult[2], 10) - 1;
    const day = parseInt(matchResult[3], 10);
    const hour = parseInt(matchResult[4], 10);
    const minute = parseInt(matchResult[5], 10);
    const second = parseInt(matchResult[6], 10);

    return Date.UTC(year, month, day, hour, minute, second, 0);
  }

  static dateToDateHhMmBrowserTz(date) {
    return toFixedWidthString(date.getFullYear(), 4) + '-'
      + toFixedWidthString(date.getMonth() + 1, 2) + '-'
      + toFixedWidthString(date.getDate(), 2) + ' '
      + toFixedWidthString(date.getHours(), 2) + ':'
      + toFixedWidthString(date.getMinutes(), 2) + ':'
      + toFixedWidthString(date.getSeconds(), 2);
  }

  static dateToShortDateInLocalTz(date) {
    return date.getFullYear() + '-'
      + toFixedWidthString(date.getMonth() + 1, 2) + '-'
      + toFixedWidthString(date.getDate(), 2);
  }

  static dateToShortDateTimeInLocalTz(date) {
    return date.getFullYear() + '-'
      + toFixedWidthString(date.getMonth() + 1, 2) + '-'
      + toFixedWidthString(date.getDate(), 2) + ' '
      + toFixedWidthString(date.getHours(), 2) + ':'
      + toFixedWidthString(date.getMinutes(), 2);
  }

  static parseShortDateTimeInLocalTz(str) {
    const r = /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2})(:(\d{2}))?/;
    const matchResult = r.exec(str);
    if (!matchResult) {
      return null;
    }
    const year = parseInt(matchResult[1], 10);
    const month = parseInt(matchResult[2], 10) - 1;
    const day = parseInt(matchResult[3], 10);
    const hour = parseInt(matchResult[4], 10);
    const minute = parseInt(matchResult[5], 10);
    const second = matchResult[7] === undefined ? 0 : parseInt(matchResult[7], 10);

    return new Date(year, month, day, hour, minute, second, 0);
  }

  static utcDateOfDefault(datetime) {
    try {
      let date = TimeFormatUtils.parseShortDateTimeInLocalTz(datetime);
      if (date === null) {
        date = new Date(datetime);
      }
      return TimeFormatUtils.formatUtcMillis(date.getTime());
    } catch (ignored) {
      return datetime;
    }
  }
}

export default TimeFormatUtils;
