import 'url-search-params-polyfill';

export function parseSearch(search) {
  return new URLSearchParams(search);
}

export function formatSearch(params) {
  return new URLSearchParams(params).toString();
}

export function boolParam(search, param, defaultValue = false) {
  const value = search.get(param);
  return value ? value === 'true' : defaultValue;
}

export function getUrlHash() {
  return window.location.hash.replace('#', '');
}

export function setUrlHash(hash) {
  window.location.hash = hash;
}

// stub
export default {};
