/* eslint-disable import/no-cycle,max-classes-per-file */
import UrlUtils from './UrlUtils';

class QueryArgNameOrValue {
  // lazily initialized
  decodedLazy;

  encoded;

  constructor(decoded, encoded) {
    this.decodedLazy = decoded;
    this.encoded = encoded;
  }

  getDecoded() {
    if (!this.decodedLazy) {
      this.decodedLazy = UrlUtils.decodeArg(this.encoded);
    }
    return this.decodedLazy;
  }

  static decoded(decoded) {
    if (decoded === null || decoded === undefined) {
      throw new Error('failed to decode query arg');
    }

    return new QueryArgNameOrValue(decoded, UrlUtils.encodeArg(decoded));
  }

  static encoded(encoded) {
    return new QueryArgNameOrValue(null, encoded);
  }

  isEmpty() {
    return this.encoded.isEmpty();
  }
}

class QueryArg {
  name;

  value;

  constructor(name, value) {
    this.name = name;
    this.value = value;
  }

  static decoded(name, value) {
    return new QueryArg(QueryArgNameOrValue.decoded(name), QueryArgNameOrValue.decoded(value));
  }

  static encoded(name, value) {
    return new QueryArg(QueryArgNameOrValue.encoded(name), QueryArgNameOrValue.encoded(value));
  }

  reconstruct() {
    return `${this.name.encoded}=${this.value.encoded}`;
  }
}

export default QueryArg;
