/* eslint-disable no-prototype-builtins,no-plusplus */
import flatMap from 'lodash/flatMap';
import WordsFromLabelValueParser from './WordsFromLabelValueParser';

function removeFirstIfNeeded(list) {
  if (list.length === 0) {
    return null;
  }

  return list.splice(0, 1)[0];
}

function generateListOfGoodPrefixes(linksWithPrefixes) {
  const result = [];

  const numLinks = linksWithPrefixes.length;

  const prefixes = flatMap(linksWithPrefixes, (tuple) => tuple[1]);

  const uniquePrefixesList = [];
  const countByPrefix = {};

  prefixes.forEach((prefix) => {
    if (countByPrefix.hasOwnProperty(prefix)) {
      countByPrefix[prefix]++;
    } else {
      countByPrefix[prefix] = 1;
      uniquePrefixesList.push(prefix);
    }
  });

  for (let i = 0; i < uniquePrefixesList.length; ++i) {
    const prefix = uniquePrefixesList[i];
    const count = countByPrefix[prefix];

    if (!(count > 1 && count < numLinks)) {
      delete countByPrefix[prefix];
      uniquePrefixesList.splice(i, 1);
      i--;
    }
  }

  let lastPrefix = null;
  let lastPrefixCount = -1;

  for (let i = 0; i < uniquePrefixesList.length; ++i) {
    const prefix = uniquePrefixesList[i];
    const prefixCount = countByPrefix[prefix];

    if (lastPrefix != null
      && prefix.startsWith(lastPrefix)
      && lastPrefixCount === prefixCount) {
      // New prefix was used in just a narrower version of previous prefix,
      // and covers same set of elements:
      // no use for previous prefix.
      if (result.length > 0) {
        result.splice(result.length - 1, 1);
      }
    }

    result.push(prefix);

    lastPrefix = prefix;
    lastPrefixCount = prefixCount;
  }

  return result;
}

function addWildcardLinks(input) {
  // eslint-disable-next-line max-len
  const linksWithAllPrefixes = input.map((link) => [link, WordsFromLabelValueParser.parsePrefixes(link)]);

  const newLinks = [];
  const allPrefixesToWildcard = generateListOfGoodPrefixes(linksWithAllPrefixes);

  let nextPrefix = removeFirstIfNeeded(allPrefixesToWildcard);

  for (let i = 0; i < linksWithAllPrefixes.length; ++i) {
    const linkWP = linksWithAllPrefixes[i];
    const link = linkWP[0];
    const prefixes = linkWP[1];

    while (nextPrefix != null && prefixes.indexOf(nextPrefix) >= 0) {
      if (nextPrefix.length !== 0) {
        const wildcard = `${nextPrefix}*`;
        newLinks.push(wildcard);
      }

      nextPrefix = removeFirstIfNeeded(allPrefixesToWildcard);
    }

    newLinks.push(link);
  }

  return newLinks;
}

export default addWildcardLinks;
