# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from datetime import datetime
import stocks3.core.stock as stock
stock.set_stocks_ft(float)
from stocks3.core.stock import *

def calc_deltas(c, p):
    print("Absolute delta:", c.absoluteDelta(p))
    print("Relative delta:", c.relativeDelta(p))

rubUnit = Unit("рубль", 10)
usdUnit = Unit("доллар", 1)

rub1 = StockWithUnit("RUB", rubUnit)
usd1 = StockWithUnit("USD", usdUnit)

USD_RUB = Quote(1, rub1, usd1) # прямая котировка - стоимость доллара в рублях
usbRubCurse = USD_RUB.make_price(datetime.today(), 27.9853)
usbRubCurseCurrent = USD_RUB.make_price(datetime.today(), 27.8880)

print("Dollar cost:", usbRubCurse.numeratorCost()) # стоимость доллара в рублях)
print("Rub cost:", usbRubCurse.numeratorCost()) # стоимость рубля в долларах)
calc_deltas(usbRubCurseCurrent, usbRubCurse)

p = usbRubCurse.toPrecision(2)
c = usbRubCurseCurrent.toPrecision(2)

calc_deltas(c, p)

