# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


import sys
sys.path.append(".")

from stocks3.core.stock import *
from datetime import datetime


one = Unit("ед", 1)
hundred = Unit("ед", 100)
gbp_100 = StockWithUnit("GBP", hundred)
uah_1 = StockWithUnit("UAH", one)
my_quote = Quote("Сколько стоит 100 фунтов в гривнах.", gbp_100, uah_1)
price = my_quote.make_price(datetime.today(), 1298.3300)
# А вот сколько стоит один фунт:
print(price.numeratorCost())
# А можно ещё и так:
price.normalize()
print(price.buy.value)
price = price * 4
print(price.buy.value)

dual_price = my_quote.make_dual_price(datetime.today(), 143, 283)
dual_price = dual_price / 3.0
print(dual_price.buy.value)
print(dual_price.sell.value)


