# -*- coding: utf-8 -*-

"""
Скрипт, запускает экспорт.

В качестве аргументов могут быть указаны имена источников, из которых данные
нужно забрать.

"""
import stocks3
import argparse
import logging
from stocks3.core.source import SourceLoader
from stocks3.export.exporter import make_exporter


def main():
    parser = argparse.ArgumentParser()

    parser.add_argument("-v", "--verbose", help="Verbose output", action='store_true', required=False)
    parser.add_argument("-t", "--tracebacks", help="Print tracebacks", action='store_true', required=False)
    parser.add_argument("-c", "--config", help="Default configurator file", required=False)
    parser.add_argument("-f", "--flag", nargs='+', help="list of exports' types", required=False)
    parser.add_argument("-q", "--quotes", nargs='+', type=int, help="export only quotes from list", required=False)
    args = parser.parse_args()

    logging.basicConfig(level=logging.DEBUG if args.verbose else logging.WARNING)
    logger = logging.getLogger('EXPORT')

    stocks3.load_modules()
    loader = SourceLoader()
    sources = loader.get_active_sources()

    try:
        exporter = make_exporter(sources, args.flag, args.quotes)
        exporter.run_export()
    except Exception as e:
        logger.error('Exception while export: ', str(e))


if __name__ == "__main__":
    main()
