#!/usr/bin/env python3
# coding: utf-8
"""
    Создает простую html страничку с списком котировок и статусами
    1) пробегаемся по котировкам
    2) выделяем котировка с ошибками
    3) отдельно выписываем сообщения об ошибках при тестах (сделать сохранение этих ошибок куданибудь)
"""
import stocks3
from stocks3.core.default import Default
from stocks3.export.exporter import make_exporter
from stocks3.core.source import SourceLoader
from stocks3.share.quotesourcemap import get_quote_source_multimap
import argparse

DEFAULT_XML = "config/default-db.xml"


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("-l", "--log", help="Just log messages", action='store_true', required=False)
    args = parser.parse_args()

    stocks3.load_modules()

    default = Default(DEFAULT_XML)
    loader = SourceLoader()
    source_map = get_quote_source_multimap([x[1] for x in loader.get_active_sources()])

    quotes = default.quotes_config.getAllQuotes()
    for name, quote in quotes:
        source_list = source_map.get(name, None)
        source_name = "None"
        if source_list is not None:
            source_name = ', '.join(['{}({})'.format(source.sourceId, source.weight) for source in source_list])
        print(quote.quote_id, "\t", name, "\t", source_name)


if __name__ == "__main__":
    main()
