# -*- coding: utf-8 -*-
import cairo
from .font import create_cairo_font_face_for_file

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def image(width, height):
    """
    Создает картинку с заданными размерами и контекст для рисования.
    """
    surface = cairo.ImageSurface(cairo.FORMAT_ARGB32, width, height)
    ctx = cairo.Context(surface)
    return surface, ctx


def set_font(ctx, font_file, font_size):
    """
    Загружает шрифт из файла и устанавливает его для контекста ctx.
    """
    # Используем нулевой face =)
    face = create_cairo_font_face_for_file(font_file, 0)
    ctx.set_font_face(face)
    ctx.set_font_size(font_size)
    return ctx

