# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from plotter.share.math.xy import X, Y
from math import fabs, sqrt
from plotter.share.math.epsilon import epsilon


def _vector_length(s, e):
    return sqrt((e[X] - s[X]) ** 2 + (e[Y] - s[Y]) ** 2)

def crop_cicle(ss, es, crop):
    """
    Усекает отрезок на величину crop.
    """
    l = _vector_length(ss, es)

    # Коэффициенты наколна линии к осям X и Y.
    kx = (es[X] - ss[X]) / l
    ky = (es[Y] - ss[Y]) / l

    cx = kx * crop[X]
    cy = ky * crop[Y]

    if fabs(ss[X] - es[X]) < epsilon:
        # Горизонтальная линия. Отсекаем только X
        ss = (ss[X], ss[Y] + crop[Y])
        es = (es[X], es[Y] - crop[Y])
    elif fabs(ss[Y] - es[Y]) < epsilon:
        # Вертикальная линия. Отсекаем только Y.
        ss = (ss[X] + crop[X], ss[Y])
        es = (es[X] - crop[X], es[Y])
    else:
        # Обычная линия. Отсекаем и X и Y.
        ss = (ss[X] + cx, ss[Y] + cy)
        es = (es[X] - cx, es[Y] - cy)
    return ss, es
