# -*- coding: utf-8 -*-
"""
Машинная эпсилон.

Машинной эпсилон называется наименьшее положительное число ε такое,
что 1 + ε /= 1 (знаком обозначено машинное сложение). Грубо говоря,
числа a и b, соотносящиеся так, что , машина не различает.

Число a и b для которых выполняется 1 < a/b < 1 + ε машина не
различает.

Используется просто:

  epsilon = calc(float)

"""
__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

__all__ = []


def calc(func=float):
    machine_epsilon = func(1)
    machine_epsilon_last = None
    while func(1)+func(machine_epsilon) != func(1):
        machine_epsilon_last = machine_epsilon
        machine_epsilon = func(machine_epsilon) / func(2)
    return machine_epsilon_last

epsilon = calc()
