# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


"""
Рисование сеток.
"""

from .axis import axis
from plotter.share.math.mc import mc10
from math import modf, fabs
from plotter.share.math.epsilon import epsilon
from plotter.share.time.unixtime import fromunixtime


_russian_months3 = ["янв", "фев", "мар", "апр", "май", "июнь",
                    "июль", "авг", "сент", "окт", "нояб", "дек"]

def make_date_label(ut):
    """
    Пишет дату.
    """
    dt = fromunixtime(ut)
    return dt.strftime("%d") + " " + _russian_months3[dt.month-1]


def draw_grid(xlabels, canvas, x_lh, y_lh, grid_color, text_color, xpadding=16, ypadding=3):
    """ Рисует простую сетку. Цвет должен быть установлен заранее.
    x_lh и y_lh можно вычислить функцией discrete_x_window, например
    (модуль share.plot.axis).

    xpadding и ypadding - смещения для надписей.
    """

    # x_lh и y_lh - это кортежи из четырех элементов, вычисляются они
    # функцией low_high.
    # Содержат:
    # step, low, high, maximum

    min_x = x_lh[1]
    max_x = x_lh[2]

    min_y = y_lh[1]
    max_y = y_lh[2]

    # Рисуем вертикальные оси.
    for x in axis(*x_lh):
        canvas.ctx.set_source_rgba(*grid_color)
        canvas.line( (x, min_y), (x, max_y) )
        if len(xlabels) > 0:
            canvas.ctx.set_source_rgba(*text_color)
            label = make_date_label(xlabels[0])
            canvas.text_x_center((x, min_y), label, xpadding)
            xlabels = xlabels[1:]

    # Рисуем горизонтальные оси.
    ys = [y for y in axis(*y_lh)]
    y_step = y_lh[0]

    # Выбираем число отображаемых знаков после запятой.
    _, c = mc10(y_step)
    if c > 0:
        #  Смотрим, есть ли у числа, большего 1 дробная часть...
        if fabs(modf(y_step)[0]) <= epsilon and \
           fabs(modf(min_y)[0]) <= epsilon:
            p = 0
        else:
            p = 1
    else:
        # Число меньше 1
        p = -c
    if p > 4:
        p = 5
    y_title_format = "%%.%sf" % p

    for y in ys[:-1]:
        canvas.ctx.set_source_rgba(*grid_color)
        canvas.line( (min_x, y), (max_x, y) )
        canvas.ctx.set_source_rgba(*text_color)
        title = y_title_format % y
        canvas.show_text( (min_x, y), title, ypadding, -ypadding )
    # Рисуем верхнюю линию без надписи.
    canvas.ctx.set_source_rgba(*grid_color)
    canvas.line( (min_x, ys[-1]), (max_x, ys[-1]) )

