# -*- coding: utf-8 -*-
from plotter.share.math import xy
from plotter.share.math.goodnumber2 import lh
from plotter.share.graph.viewport import window

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def window_from_lh(x_lh, y_lh):
    """
    Окно высчитываем по границам рядов.
    """
    minx = x_lh[1]
    maxx = x_lh[2]

    miny = y_lh[1]
    maxy = y_lh[2]

    return window((minx, miny), (maxx, maxy))
    

def discrete_x_lh(plot, x_start=0.0, func=float):
    """
    Вычисляет подходящее окно для кусочка графика plot.
    Ось x считается дискретной с шагом 1.
    """
    maximum = max(xy.projection_2d(xy.X, plot))
    if maximum == 0:
        maximum = 1.0
    x_lh = (1.0, func(x_start), func(maximum))
    return x_lh


def calc_y_lh(plot, n=5):
    sequence = xy.projection_2d(xy.Y, plot)
    minimum = min(sequence)
    maximum = max(sequence)
    return lh(minimum, maximum, n)
