# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from .timezone import withtz
from datetime import datetime
from time import mktime, time


def _to_unixtime(dt):
    return int(mktime(dt.timetuple()))

def unixtime(tz, dt):
    """
    Преобразует дату dt в U{unixtime <http://ru.wikipedia.org/wiki/UNIX-время>}.

    Пример работы:

    >>> tzset("Europe/Moscow")
    >>> dt = datetime.strptime("07.07.2011 17:53:12", "%d.%m.%Y %H:%M:%S")
    >>> to_unixtime(dt)
    1310046792.0
    >>> to_unixtime(dt, "Europe/London")
    1310057592.0

    @type dt: datetime
    @param dt: Дата и время.
    @type tz: человеческое имя временной зоны
    @param tz: Временная зона, в которой задано время dt. Если время считается
               заданным в системной временной зоне.
    """
    assert isinstance(dt, datetime), "Expected datetime, but received %s" % dt.__class__
    if tz:
        return withtz(tz, _to_unixtime, dt)
    else:
        return _to_unixtime(dt)


def today():
    return int(time())


def fromunixtime(ut):
    return datetime.fromtimestamp(int(ut))
