# -*- coding: utf-8 -*-
"""
Разбор graphmin_${id}.json
"""
import json


def parse_graphxml(content):
    """
    Разбирает файл с параметрами графика.
    """
    graph_data = json.loads(content)
    for price in graph_data['prices']:
        yield int(price[0]/1000), float(price[1])


if __name__ == "__main__":
    import sys

    for graph in sys.argv[1:]:
        try:
            with open(graph, "r") as f:
                for x, y in parse_graphxml(f.read()):
                    print(x, y)
        except IOError as e:
            pass
