#!/bin/bash

LOCK_FILE="stocks-bigexport.flock"
LOCK_DIR="/tmp"
LOCK_FD=200

lock () {
  eval "exec ${LOCK_FD}>${LOCK_DIR}/${LOCK_FILE}"

  flock -n ${LOCK_FD} \
    && return 0 \
    || return 1
}

doBigExport () {
  /opt/www/stocks3/runners/export -f item,all,index,png,device >/dev/null 2>&1
}

main () {
  lock || exit 1

  doBigExport
}

main
