#!/bin/bash

# Создаем графики для телевизора SAMSUNG.
# Скрипт использует экспорты graph_*.xml

cd $(dirname $0)

PYTHONPATH=.:${PYTHONPATH}

# Директория с данными.
GD=/opt/www/stocks/data/xmlhist
# Директория в которой будут лежать графики для теликов SAMSUNG.
SAMSUNG=/opt/www/stocks/data/export/samsung
mkdir -p ${SAMSUNG}

# Глубина выходного изображения.
DEPTH=8
# Земля.
EARTH=10000

FONT=fonts/yandex_sans_medium.ttf

# Функция выдирает идентификатор котировки из имени графика.
# graphmin_23.json -> qid=23
function calc_qid() {
    qid=$(basename `echo $1` | cut -d. -f1 | cut -d_ -f2)
}

# Собственно создает график.
function create_samsung_plot() {
    calc_qid $1
    output=$2/${qid}.png
    if [[ ${qid} == "*" ]]; then
        return 0
    fi
    echo ${output}
    
    # Создаем график (сохраняем во временный файл).
    TMP=$(mktemp)
    trap "rm -f ${TMP}" EXIT
    python3 -mplotter.stocks.graph $1 | python3 -mplotter.samsung -f ${FONT} -o ${TMP}

    # Сжимаем картинку, изменяя глубину.
    TMP2=$(mktemp)
    trap "rm -f ${TMP2}" EXIT
    convert -depth ${DEPTH} ${TMP} ${TMP2}
    rm ${TMP}

    # Переносим картинку на постоянное место.
    mv ${TMP2} ${output}
    chmod 0666 ${output}
}

# Земельные графики.
for f in ${GD}/graphmin_*.json; do
    calc_qid ${f}
    destdir=${SAMSUNG}/${EARTH}
    mkdir -p ${destdir}
    create_samsung_plot ${f} ${destdir}
done

# Региональные графики.
for r in ${GD}/*; do
    if [[ -d ${r} ]]; then
        region=$(basename ${r})
        for f in ${r}/graphmin_*.json; do
            destdir=${SAMSUNG}/${region}
            mkdir -p ${destdir}
            create_samsung_plot ${f} ${destdir}
        done
    fi
done

