# -*- coding: utf-8 -*-
"""
Пакет Котировки3.
=================

Сбор данных о котировках - это задача конвейера, состоящего из:
    1. Транспорта (L{Transport}), который считывает данные из источника и
       сохраняет в заданном месте (L{Place}).
    2. Парсера (L{Parser}), который разбирает данные, считанные транспортом и
       представляет их в виде объектов класса L{Price}.
    3. Калькуляторов (L{Calculator}), которые вычисляют дополнительные поля
       объектов класса L{Price}.
    4. Модуля сохранения (L{Saver}), который обработанные данные сохраняет.

Конфигурация конвейера описывается в XML-файлах.

Каждый узел XML-файла может иметь атрибут class, в котором содержится
имя класса объекта, занимающего определенное место в конвейере. Некоторые
объекты поддерживают дополнительные параметры (нужно смотреть документацию к
конкретному классу).

Чтобы узнать, какие классы есть в системы, можно использовать программку
s3structure.

"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def load_modules():
    from . import core
    from . import transports
    from . import parsers
    from . import calculators
    from . import checkers
    from . import savers
    from . import readers
    from . import qcalculators
    from . import templaters
