# -*- coding: utf-8 -*-

"""
Используется для тестов. Просто печатает все, что мне нужно.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.core.factories import calculators
from stocks3.core.calculator import Calculator
from stocks3.core.sharedregion import SHARED_REGION


class Printca(Calculator):
    def calc(self, source, price):
        if price.is_dual_price:
            print("q:%s, r:%s, d:%s [%s], b:%s, s:%s" % (price.quote.quote_id, price.region, price.date, price.tz, price.buy.value, price.sell.value))
        else:
            print("q:%s, r:%s, d:%s [%s], b:%s" % (price.quote.quote_id, price.region, price.date, price.tz, price.buy.value))
        return price

def print_sql(source, price):
        quoteId, region, date, buy, unixtime = \
                price.quote.quote_id, price.region, price.date, price.buy.value, int(price.unixtime)
        if region is None:
            region = SHARED_REGION
        if price.is_dual_price:
            sell = price.sell_value
        else:
            sell = 'NULL'
        print("INSERT INTO stocks (id, region, src, s_date, s_time, value, sell_value, s_unixtime) VALUES")
        print("  (%s, %s, %s, '%s', '%s', %s, %s, %s);" % (quoteId, region, source.sourceInnerId,
                                                           date.strftime("%Y-%m-%d"), date.strftime("%H:%M:%S"),
                                                           buy, sell, unixtime))

class SqlPrintca(Calculator):
    def calc(self, source, price):
        print_sql(source, price)
        return price

calculators.register("stocks3.calculators.printca", Printca)
calculators.register("stocks3.calculators.sqlprintca", SqlPrintca)

