# -*- coding: utf-8 -*-

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from stocks3.core.checker import Checker
from stocks3.core.factories import checkers


class BuySellChecker(Checker):
    def check(self, price):
        """
        Не пропускаем значения, для которых цена покупки больше, чем цена
        продажи. Проверяются только двойные котировки (то есть те, для которых
        стоит флажок 'dual' в config/quotes.json).
        """
        if price.is_dual_price:
            return price.buy.value > price.sell.value
        else:
            return True


checkers.register("stocks3.checkers.BuySell", BuySellChecker)

