# -*- coding: utf-8 -*-

"""
Калькулятор - это объект, который вычисляет значения дополнительных полей.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


from stocks3.core.source import BaseSource
from stocks3.core.config import Configurable
from stocks3.core.stock import AbstractPrice
from stocks3.core.exception import S3Exception, throw_only
from stocks3.core.default import Default


class S3CalculatorError(S3Exception):
    STAGE = "calculator"


class Calculator(Configurable):

    def __init__(self, tree, node, default):
        assert isinstance(default, Default), "For Calculator expected Default."
        self.default = default
        Configurable.__init__(self, tree, node)

    def save_value(self, obj, field, value):
        setattr(obj, field, value)

    def calc(self, source, price):
        assert isinstance(source, BaseSource), "Expected Source. Received - %s" % source.__class__
        assert isinstance(price, AbstractPrice), "Expected Price. Received - %s" % price.__class__

    @throw_only(S3CalculatorError)
    def run_calc(self, source, price):
        return self.calc(source, price)

