# -*- coding: utf-8 -*-

"""
Модуль проверки данных.

Некоторые источники врут. Поэтому перед записью выполняется проверка этих данных.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

from stocks3.core.config import Configurable
from stocks3.core.exception import S3Exception, throw_only


class S3CheckerError(S3Exception):
    STAGE = "checker"


class Checker(Configurable):
    def __init__(self, tree, node, source):
        """
        Модуль проверки связан с источником. Часто требуется сделать запрос в
        базу данных.
        """
        Configurable.__init__(self, tree, node)
        self.source = source

    def _get_saver(self): return self.source.saver
    saver = property(_get_saver)

    def check(self, price):
        """
        Проверяет данные котировки (price). Возвращает True, если данные в
        порядке и False в противном случае.
        """
        return False

    @throw_only(S3CheckerError)
    def run_check(self, price):
        return self.check(price)

