def get_field(data, path, safe=False, full_path=None, default=None):
    if isinstance(path, str):
        path_list = path.split('.')
    elif isinstance(path, list):
        path_list = path
    else:
        if not safe:
            raise AttributeError('Invalid path for json: "{}"'.format(path))
        else:
            return default

    if full_path is None:
        full_path = '.'.join(path_list)

    if len(path_list) == 0:
        return data

    field_name = path_list.pop(0)
    if field_name == '':
        return data

    if field_name.isdigit() and isinstance(data, list):
        rest = data[int(field_name)]
        return get_field(rest, path_list, safe=safe, full_path=full_path, default=default)

    if not isinstance(data, dict):
        if safe:
            return default
        raise KeyError('Failed to get path `{}` from json'.format(full_path))

    if field_name in data:
        rest = data[field_name]
        return get_field(rest, path_list, safe=safe, full_path=full_path, default=default)
    else:
        if safe:
            return default
        raise KeyError('Failed to get path `{}` from json'.format(full_path))


def is_number(s):
    try:
        float(s)    # for int, long and float
    except ValueError:
        return False

    return True
