# -*- coding: utf-8 -*-

"""
Параметры по умолчанию.
"""

from stocks3.core.config import Configurable, parse_xml
from stocks3.core import factories
from stocks3.core.quotesconfig import QuotesConfig

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


class Default(Configurable):
    """
    Общие параметры для всех модулей.
    """

    DEFAULT_TIMEZONE = "Europe/Moscow"
    DEFAULT_SOURCES_DIR = "catalog/sources"

    def __init__(self, default_xml):
        tree = parse_xml(default_xml)
        # FIXME: необходимо выделить класс WithDefault
        self.default = self
        Configurable.__init__(self, tree, tree.getroot())
        self.quotes_config = QuotesConfig(self.get_quotes_config_file())

    def makeConfig(self):
        self.tz = self.readString("", "timezone", self.DEFAULT_TIMEZONE)
        self.sources_directory = self.readString("", "sources-directory", self.DEFAULT_SOURCES_DIR)
        self.finam_config = self.readString("", "finam-config")
        self.transport_attempts = self.readInt("", "transport-attempts", 1)
        self.transport_sleep = self.readInt("", "transport-sleep", 1)
        return self

    def getDefaultCalculators(self):
        return self.createObjects(factories.calculators, "calculators/calculator", self)

    def getDefaultSaver(self, source):
        places = self.createObjects(factories.savers, "saver", source)
        return places[0] if len(places) != 0 else None

    def get_quotes_config_file(self):
        """
        Возваращет путь до файла со списком котировок.
        """
        return self.readString("", "quotes")


