# -*- coding: utf-8 -*-

"""
Функции для группировки котировок по различным критериям.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


def group_by_region(quotes):
    """
    Принимает на вход список кортежей:
        (quote, {"region": prices})
    Возвращает словарь вида:
        "region": {"quote": prices}

    Сделано для генерации device.xml.
    """
    grouped = {}
    for quote, regions in quotes:
        for region, prices in regions.items():
            if region not in grouped:
                grouped[region] = {}
            grouped[region][quote] = prices
    return grouped


def update_env(ns):
    """
    Обновляет окружение для шаблонизатора.
    Смотрим L{Templater.make_default_env}.
    """
    ns["group_by_region"] = group_by_region

