# -*- coding: utf-8 -*-

"""
Некоторые котировки (смотри L{AbstractPrice}) могут быть актуальны лишь для
определенного региона. Но есть также котировки, которые действительны для всех
регионов. Поэтому принято считать регион с идентификатором 0 -любым регионом.
"""

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"

SHARED_REGION = 0


def fix_earth_region(region):
    """
    Исправляем регион для Земли.
    Дело в том, что в базе этот регион называется 0, а в геобазе - 10000.
    """
    # return 10000 if region is None or region == 0 else region
    return region if region != 0 else 10000
