# -*- coding: utf-8 -*-

"""
Модуль контролирует имена товаров (не котировок).
"""
from stocks3.share.singleton import Singleton
import json


class StocksCatalog(object, metaclass=Singleton):
    stocks_data = "catalog/stocks.json"

    def __init__(self):
        with open(self.stocks_data, encoding="utf-8") as f:
            self.stocks_units = json.load(f)

        self.stocks_units = self.stocks_units['stocks']

    def is_valid_stock(self, stock):
        return stock in self.stocks_units

    def get_unit(self, name):
        """
        Для товара name возвращает единицу измерения по умолчанию.
        """
        return self.stocks_units[name]['unit']

