# -*- coding: utf-8 -*-

"""
Модуль для отображения идентификаторов котировок на сами котировки (то есть
объекты).

Тестовый модуль.
"""

from stocks3.share.singleton import Singleton
from stocks3.core.stock import *


__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


rubUnit = Unit("рубль", 1)
usdUnit = Unit("доллар", 1)

rub1 = StockWithUnit("RUB", rubUnit)
usd1 = StockWithUnit("USD", usdUnit)

USD_RUB = Quote(1, rub1, usd1)  # прямая котировка - стоимость доллара в рублях
RUB_USD = Quote(2, usd1, rub1)


class StocksMapper(object, metaclass=Singleton):

    def getStock(self, stockId):
        if stockId == 1:
            return USD_RUB
        else:
            return RUB_USD

