# -*- coding: utf-8 -*-

"""
Парсер данных для apps.shareholder.com.
"""
from stocks3.parsers.xml import XMLParser
from stocks3.core.factories import parsers

__author__ = "Zasimov Alexey"
__email__ = "zasimov-a@yandex-team.ru"


class AppsShareholderComParser(XMLParser):
    """
    Парсер данных для apps.shareholder.com.
    """
    def parse(self, place):
        XMLParser.parse(self, place)

        tree = self.dataTree
        row_nodes = tree.findall('RESULT/ROW')
        for row in row_nodes:
            source_quote_id = row.find('TICKER').text
            # Разбираем время и получаем значение котировки
            source_datetime = row.find('LASTDATETIME').text
            # фикс для HOME-29655 (морда не учитывает таймзону для получения даты
            # из unixtime - показывает неправильную дату)
            if '16:00:00' in source_datetime:
                source_datetime = source_datetime.replace('16:00:00', '15:59:59')
            value = float(row.find('LASTPRICE').text)
            price = self.default_map.make_price_date(source_quote_id, source_datetime, value)
            if price is not None:
                yield price


parsers.register("stocks3.parsers.AppsShareholderCom", AppsShareholderComParser)

