# -*- coding: utf-8 -*-

"""
Парсим турецкий сайт с валютами - bigparam.com.
"""
from __future__ import print_function

__author__ = "Bogdanov Evgeniy"
__email__ = "evbogdanov@yandex-team.ru"

from stocks3.parsers.xml import NewXMLParser
from stocks3.core.factories import parsers
from stocks3.share.db import DB_PRECISION


class BigparaParser(NewXMLParser):

    def parse(self, place):
        NewXMLParser.parse(self, place)

        if 'bigpara' in self.data and \
                'serbestpiyasa' in self.data['bigpara'] and \
                'kalem' in self.data['bigpara']['serbestpiyasa']:
            for quote in self.data['bigpara']['serbestpiyasa']['kalem']:
                quote_id = quote['kod']
                source_date = quote['tarih']
                buy_value = round(float(quote['satis'].replace(',', '.')), DB_PRECISION)
                sell_value = round(float(quote['alis'].replace(',', '.')), DB_PRECISION)
                price = self.default_map.make_dual_price_date(quote_id, source_date, buy_value, sell_value)
                if price is not None:
                    yield price


parsers.register("stocks3.parsers.Bigpara", BigparaParser)
